/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg + Joerg Habenicht                            **
**                                                                           **
** vector definition file                                                    **
** with these arrays, various pointers can be stored and fetched in the      **
** order they were stored into the array                                     **
** without thinking about the linked list pointer arithmetics                **
**                                                                           **
\*****************************************************************************/ 

#include <assert.h>

#include "vector.h"


#if 0
template <class ArrayItem> const int Vector<ArrayItem>::startsize = 10; // 10 elements
template <class ArrayItem> const int Vector<ArrayItem>::incrsize = 10;


template <class ArrayItem> Vector<ArrayItem>::Vector()
{
  arraysize = startsize;
  array = new ArrayItem [arraysize];
  itemnum = 0;
}
template <class ArrayItem> Vector<ArrayItem>::Vector(Vector &copy)
{
  arraysize = copy.arraysize;
  array = new ArrayItem [arraysize];
  itemnum = copy.itemnum;
  for (int i=0; i<itemnum; i++)
  {
    array[i] = copy.array[i];
  }
}

template <class ArrayItem> Vector<ArrayItem>::~Vector()
{
  delete[] array;
}


template <class ArrayItem> void Vector<ArrayItem>::add(const ArrayItem item)
{
  /* if the storage is full, get a new storage and copy all content into
   * then add the item at the end */
  assert (itemnum <= arraysize);
  if ( itemnum >= arraysize )
  {
    ArrayItem *newarray;

    arraysize += incrsize;
    newarray = new ArrayItem [arraysize];
    for (int i=0; i<itemnum; i++)
    {
      newarray[i] = array[i];
    }
    delete[] array;
    array = newarray;
  }
  
  array[itemnum++] = item;
}

template <class ArrayItem> int Vector<ArrayItem>::remove(const ArrayItem item)
{
  int i;
  int have_found = 0;
  
  for (i=0; i<itemnum; i++)
  {
    if ( item == array[i] )
    {
      /* found one. move the rest, closing the gap */
      have_found = 1;
      for ( ; i<(itemnum-1); i++ )
      {
        array[i] = array[i+1];
      }
      
      itemnum--;
      
      break;
    }
  }

  return have_found;
}

template <class ArrayItem> ArrayItem const * const Vector<ArrayItem>::get() const
{
  return array;
}

template <class ArrayItem> int Vector<ArrayItem>::size() const
{
  return itemnum;
}



template <class ArrayItem> AutodeleteVector<ArrayItem>::AutodeleteVector()
 : Vector<ArrayItem>()
{
  do_delete_item = new bool [Vector<ArrayItem>::arraysize];
}

template <class ArrayItem> AutodeleteVector<ArrayItem>::AutodeleteVector(AutodeleteVector &copy)
 : Vector<ArrayItem>(copy)
{
  do_delete_item = new bool [Vector<ArrayItem>::arraysize];
  for (int i=0; i<Vector<ArrayItem>::itemnum; i++)
  {
    do_delete_item[i] = copy.do_delete_item[i];
  }
}

template <class ArrayItem> AutodeleteVector<ArrayItem>::~AutodeleteVector()
{
  for (int i=0; i<Vector<ArrayItem>::itemnum; i++)
  {
    if ( do_delete_item[i] )
      delete Vector<ArrayItem>::array[i];
  }

  delete[] do_delete_item;
}



template <class ArrayItem> void AutodeleteVector<ArrayItem>::add(const ArrayItem item)
{
  this->add(item, true);
}

template <class ArrayItem> void AutodeleteVector<ArrayItem>::add(const ArrayItem item, bool doAutodelete)
{
  /* if the storage is full, get a new storage and copy all content into
   * then add the item at the end */
  int asize = Vector<ArrayItem>::arraysize;
  Vector<ArrayItem>::add(item);
  if ( asize != Vector<ArrayItem>::arraysize )
  {
    bool *newbool = new bool[Vector<ArrayItem>::arraysize];
    
    for (int i=0; i<(Vector<ArrayItem>::itemnum-1); i++)
    {
      newbool[i] = do_delete_item[i];
    }
    delete[] do_delete_item;
    do_delete_item = newbool;
  }
  
  do_delete_item[Vector<ArrayItem>::itemnum] = doAutodelete;
}

template <class ArrayItem> int AutodeleteVector<ArrayItem>::remove(const ArrayItem item)
{
  int i;
  int have_found = 0;
  
  for (i=0; i<Vector<ArrayItem>::itemnum; i++)
  {
    if ( item == Vector<ArrayItem>::array[i] )
    {
      /* found one. move the rest, closing the gap */
      have_found = 1;
      for ( ; i<(Vector<ArrayItem>::itemnum-1); i++ )
      {
        Vector<ArrayItem>::array[i] = Vector<ArrayItem>::array[i+1];
        do_delete_item[i] = do_delete_item[i+1];
      }
      
      Vector<ArrayItem>::itemnum--;
      
      break;
    }
  }

  return have_found;
}
#endif

#if 0
int testtemp()
{
  Vector<char*> vc;
  
  char that[1], *those;	// array items
  char*const*arr;	// list returned from vector
  int size;
  
  vc.add(that);
  size = vc.size();
  arr = vc.get();
  arr[0][0] = '\0';// allowed
  //arr[0] = 0;	//not allowed
  arr = 0;	// allowed
  vc.remove(those);  
  
  return 0;
}
#endif
