// endpoint implementation for pbx endpoint

#include <ptlib.h>


#include <codec/silencedetect.h>
#include <opal/call.h>
#include <opal/patch.h>
#include <opal/manager.h>

#include "opal_pbxep.h"


#define new PNEW


PBXEndPoint::PBXEndPoint(OpalManager & mgr, const char * prefix)
  : OpalEndPoint(mgr, prefix, CanTerminateCall)
{
	PDEBUG(DEBUG_OPAL, "PBXEndpoint created\n");
}


PBXEndPoint::~PBXEndPoint()
{
	PDEBUG(DEBUG_OPAL, "PBXEndpoint terminated\n");
}


BOOL PBXEndPoint::MakeConnection(OpalCall& call, const PString &remoteParty, void *userData)
{
	char prefix[64], prefixname = GetPrefixName();

	// prefix
	if (strchr(prefixname, ':'))
		SCPY(prefix, strchr(prefixname,':')+1);
	else
		SCPY(prefix, prefixname);

todo portid muss uebergeben werden
  	connection = new PBXConnection(call, *this, unsigned long port_id);
	if (!connection)
		return FALSE;

	connectionsActive.SetAt(connection->GetToken(), connection);

	// If we are the A-party then need to initiate a call now in this thread and
	// go through the routing engine via OnIncomingConnection. If we are the
	// B-Party then SetUpConnection() gets called in the context of the A-party
	// thread.
	if (call.GetConnection(0) == connection)
		connection->InitiateCall();

	return TRUE;
}


OpalMediaFormatList PBXEndPoint::GetMediaFormats() const
{
	OpalMediaFormatList formats;

	if (options.law == 'u')
		formats += Opal_G711_ULAW_64K;
	if (options.law == 'a')
		formats += Opal_G711_ALAW_64K;

	AddVideoMediaFormats(formats);

	return formats;
}




