/* opal manager */

#include <ptlib.h>

#include <opal/buildopts.h>

#if OPAL_SIP
#include <sip/sip.h>
#endif

#if OPAL_H323
#include <h323/h323.h>
#include <h323/gkclient.h>
#endif

#if OPAL_IAX2
#include <iax2/iax2.h>
#endif

#include <ptclib/pstun.h>

#include "main.h"
#include "opal_mgr.h"


#ifdef OPAL_STATIC_LINK
#define H323_STATIC_LIB
#include <codec/allcodecs.h>
#endif


#define new PNEW


PBXManager::PBXManager()
{
  pbxEP = NULL;
#if OPAL_H323
  h323EP = NULL;
#endif
#if OPAL_SIP
  sipEP  = NULL;
#endif
#if OPAL_IAX2
  iax2EP  = NULL;
#endif
}

PBXManager::~PBXManager()
{
}


// Configure manager
// Create and configure endpoints

BOOL PBXManager::Initialise()
{
//	SetSilenceDetectionMode(options.voip_sildetect ? H323AudioCodec::NoSilenceDetection : H323AudioCodec::AdaptiveSilenceDetection);

	// set jitter
	if (option.voip_minjitter >= 20 && option.voip_minjitter <= option.voip_maxjitter && option.voip_maxjitter <= 1000)
		SetAudioJitterDelay(option.voip_minjitter, option.voip_maxjitter);
	else
	{
		PERROR_RUNTIME("Jitter should be between 20 and 1000 milliseconds. (check voip_minjitter and voip_maxjitter in options.conf)\n");
		return FALSE;
	}
	cout << "Jitter buffer: "  << GetMinAudioJitterDelay() << '-' << GetMaxAudioJitterDelay() << " ms\n";

	// disable useless codecs
	PStringArray masks;
	masks += OPAL_PCM16;
	masks += OPAL_L16_MONO_8KHZ;
	masks += OPAL_L16_MONO_16KHZ;
	todo do exactly as in h323_ep....
	SetMediaFormatMask(masks);
	cout <<	"Codecs removed: " << setfill(',') << GetMediaFormatMask() << "\n";

	// codec priority
	PStringArray masks;
	todo do exactly as in h323_ep....
	SetMediaFormatOrder(order);
	cout <<	"Codec order: " << setfill(',') << GetMediaFormatOrder() << setfill(' ') << "\n";

	// IP translation
	if (options.voip_translate[0])
	{
		SetTranslationAddress(options.voip_translate);
		cout << "External address set to " << GetTranslationAddress() << "\n";
	}

	// port range / TOS
	if (options.voip_portbase)
	{
		SetTCPPorts(options.voip_portbase, options.voip_portmax);
		SetUDPPorts(options.voip_portbase, options.voip_portmax);
		SetRtpIpPorts(options.voip_portbase, options.voip_portmax);
	} else
	{
		if (options.voip_tcpbase)
			SetTCPPorts(options.voip_tcpbase, options.voip_tcpmax);

		if (options.voip_udpbase)
			SetUDPPorts(options.voip_udpbase, options.voip_udpmax);

		if (options.voip_rtpbase)
			SetRtpIpPorts(options.voip_rtpbase, options.voip_rtpmax);
	}
	if (options.voip_rtptos)
	{
		if (options.voip_rtptos > 255 || options.voip_rtptos < 0)
		{
			PERROR_RUNTIME("IP Type Of Service bits must be 0 to 255.\n");
			return FALSE;
		}
		SetRtpIpTypeofService(optiosn.voip_rtptos);
	}
	cout << "TCP ports: " << GetTCPPortBase() << '-' << GetTCPPortMax() << "\n"
		"UDP ports: " << GetUDPPortBase() << '-' << GetUDPPortMax() << "\n"
		"RTP ports: " << GetRtpIpPortBase() << '-' << GetRtpIpPortMax() << "\n"
		"RTP IP TOS: 0x" << hex << (unsigned)GetRtpIpTypeofService() << dec << "\n";

	// stun
	cout << "STUN server: " << flush;
	if (options.voip_stun)
		SetSTUNServer(options.voip_stun);

	if (stun != NULL)
		cout << stun->GetServer() << " replies " << stun->GetNatTypeName();
	else
		cout << "None";
	cout << '\n';


#if OPAL_H323
	// Create H.323 protocol handler
	if (!options.h323_disable)
	{
		h323EP = new pbxH323EndPoint(*this);
		if (!h323EP)
		{
			PERROR_RUNTIME("Failed to create H.323 endpoint.\n");
			return FALSE;
		}

		// Disable faststart
		h323EP->DisableFastStart(options.h323_nofaststart > 0);
      		cout "H.323 FastConnect is " << (h323EP->IsFastStartDisabled() ? "off" : "on") << "\n";

		// Disable tunneling
      		cout "H.323 H245Tunnelling is " << (h323EP->IsH245TunnelingDisabled() ? "off" : "on") << "\n";
    		h323EP->DisableH245Tunneling(options.h323_noh245tunneling > 0);

		// Get local username and aliases
		if (options.h323_user[0])
		{
			h323EP->SetLocalUserName(options.h323_user);
			//h323EP->AddAliasName(aliases[i]);
		}
    		cout << "H.323 Local username: " << h323EP->GetLocalUserName() << "\n" ;

		// Set bandwidth limit
		if (options.h323_bandwidth)
			h323EP->SetInitialBandwidth(options.h323_bandwidth);

		/* Set gatekeeper token ID */
		if (options.h323_gktoken[0])
			h323EP->SetGkAccessTokenOID(options.h323_gktoken);
		cout "H.323 gk Token OID is " << h323EP->GetGkAccessTokenOID() << endl;



		// Start the listener thread for incoming calls.
		PStringArray listeners;
		listeners += options.h323_listen;
		if (!h323EP->StartListeners(listeners))
		{
			cerr <<  "Could not open any H.323 listener from " << setfill(',') << listeners << endl;
			return FALSE;
		}

		// Set gatekeeper password
		if (options.h323_gkpw[0])
			h323EP->SetGatekeeperPassword(options.h323_gkpw);

		// Establish link with gatekeeper if required.
		if (!options.h323_nogk)
		{
      			cout << "Gatekeeper: " << flush;
			if (h323EP->UseGatekeeper(options.h323_gkkost, options.h323_gkidentifer, options.h323_gkinterface))
				cout << *h323EP->GetGatekeeper() << endl;
			else
			{
				cout << "none." << endl;
				cerr << "Could not register with gatekeeper";
				if (!options.h323_gkidentifer[0])
					cerr << " id \"" << options.h323_gkidentifer << '"';
				if (!options.h323_gkhost[0])
					cerr << " at \"" << options.h323_gkhost << '"';
				if (!options.h323_gkinterface[0])
					cerr << " on interface \"" << options.h323_gkinterface << '"';
				if (h323EP->GetGatekeeper() != NULL)
				{
					switch (h323EP->GetGatekeeper()->GetRegistrationFailReason())
					{
						case H323Gatekeeper::InvalidListener :
						cerr << " - Invalid listener";
						break;
						case H323Gatekeeper::DuplicateAlias :
						cerr << " - Duplicate alias";
						break;
						case H323Gatekeeper::SecurityDenied :
						cerr << " - Security denied";
						break;
						case H323Gatekeeper::TransportError :
						cerr << " - Transport error";
						break;
						default :
						cerr << " - Error code " << h323EP->GetGatekeeper()->GetRegistrationFailReason();
					}
				}
				cerr << '.' << endl;
			}
		}
	}
#endif

#if OPAL_SIP
	// Create SIP protocol handler
	if (!options.sip_disable)
	{
		sipEP = new pbxSIPEndPoint(*this);
		if (!sipEP)
		{
			PERROR_RUNTIME("Failed to create SIP endpoint.\n");
			return FALSE;
		}

		// Set user agent
		if (options.sip_useragent[0])
			sipEP->SetUserAgent(options.sip_useragent);

		if (options.sip_proxy[0])
		sipEP->SetProxy(options.sip_proxy);

		// set MIME format
		sipEP->SetMIMEForm(options.sip_longmime > 0);

		// Get local username
		if (options.sip_user[0])
		{
			sipEP->SetDefaultLocalPartyName(options.sip_user);
		}
    		cout << "SIP Local username: " << h323EP->GetLocalUserName() << "\n" ;

		// set retry timeouts
		sipEP->SetRetryTimeouts(10000, 30000);

		// Start the listener thread for incoming calls.
		PStringArray listeners;
		listeners += options.sip_listen;
		if (!sipP->StartListeners(listeners))
		{
			cerr <<  "Could not open any SIP listener from " << setfill(',') << listeners << endl;
			return FALSE;
		}

		// Set Registrar
		if (options.sip_registrar[0])
		{
			PStringArray registrar;
			registrar += options.sip_registrar;
			cout << "Using SIP registrar " << registrar << " ... " << flush;
			if (sipEP->Register(registrar, options.sip_registraruser, options.sip_registrarpw, options.sip_registrardomain))
				cout << "done.";
			else
				cout << "failed!";
			cout << endl;
		}
	}
#endif

	pbxEP = new PBXEndPoint(*this);
	if (!pbxEP)
	{
		PERROR_RUNTIME("Failed to create PBX endpoint. (OPAL)\n");
		return FALSE;
	}

	// Set the dial peers
#if OPAL_SIP
	AddRouteEntry("pbx:.*  = sip:<da>");
	AddRouteEntry("sip:.*  = pbx:<da>");
#endif

#if OPAL_H323
	AddRouteEntry("pbx:.*  = h323:<da>");
	AddRouteEntry("h323:.* = pbx:<da>");
#endif

#if OPAL_IAX2
	AddRouteEntry("pbx:.*  = iax2:<da>");
	AddRouteEntry("iax2:.* = pbx:<da>");
#endif

	return TRUE;
}



BOOL MyManager::OnOpenMediaStream(OpalConnection & connection, OpalMediaStream & stream)
{
	if (!OpalManager::OnOpenMediaStream(connection, stream))
		return FALSE;

	PDEBUG(DEBUG_OPAL, "%s started %s %s\n", connection.GetEndPoint().GetPrefixName(), stream.IsSource()?"sending":"receiving", stream.GetMediaFormat());  

	return TRUE;
}


