/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg                                              **
**                                                                           **
** call header file                                                          **
**                                                                           **
\*****************************************************************************/ 

#ifndef CALL_H
#define CALL_H

/* call
 *
 * calls connect interfaces together
 * calls are linked in a chain
 * interfaces can have 0, 1 or more references to a call
 * the call can have many references to interfaces
 * calls receive and send messages
 */

#define RECORD_BUFFER_SIZE	16000

enum { /* relation types */
	RELATION_TYPE_CALLING,	/* initiator of a call */
	RELATION_TYPE_SETUP,	/* interface which is to be set up */
	RELATION_TYPE_CONNECT,	/* interface is connected */
};

enum { /* relation audio state */
	CHANNEL_STATE_CONNECT,	/* endpoint is connected to the call voice transmission in both dirs */
	CHANNEL_STATE_HOLD,	/* endpoint is on hold state, no audio */
};

enum { /* states that results from last notification */
	NOTIFY_STATE_ACTIVE, /* just the normal case, the party is active */
	NOTIFY_STATE_SUSPEND, /* the party is inactive, because she has parked */
	NOTIFY_STATE_HOLD, /* the party is inactive, because she holds the line */
	NOTIFY_STATE_CONFERENCE, /* the parties joined a conference */
};


struct call_relation { /* relation to an interface */
	struct call_relation *next;	/* next node */
	int type;			/* type of relation */
	unsigned long epoint_id;	/* interface to link call to */
	int channel_state;		/* if audio is available */
	int rx_state;			/* current state of what we received from endpoint */
	int tx_state;			/* current state of what we sent to endpoint */
};

class Call
{
	public:
	Call(class Endpoint *epoint);
	~Call();
	class Call *next;		/* next node in list of calls */
	void message_epoint(unsigned long epoint_id, int message, union parameter *param);
	int handler(void);

	unsigned long c_serial;		/* serial/unique number of call */

	char c_caller[32];		/* caller number */
	char c_caller_id[32];		/* caller id to signal */
	char c_dialed[1024];		/* dial string of (all) number(s) */
	char c_todial[32];		/* overlap dialing (part not signalled yet) */
	
	int c_mixer;			/* mixer must be updated */
	struct call_relation *c_relation; /* list of endpoints that are related to the call */

	int c_partyline;		/* if set, call is conference room */

	void mixer(void);
	void call_mixer(unsigned long epoint_from, struct call_relation *relation_from, union parameter *param);
	void remove_relation(struct call_relation *relation);
	struct call_relation *add_relation(void);
}; 

extern class Call *call_first;

class Call *find_call_id(unsigned long call_id);

void call_debug(class Call *call, char *function);
void call_free(void);
void call_release(unsigned long call_id, unsigned long epoint_id, int hold, int location, int cause);
int call_countrelations(unsigned long call_id);
int track_notify(int oldstate, int notify);

#endif
