/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg                                              **
**                                                                           **
** sip-port header file                                                      **
**                                                                           **
\*****************************************************************************/ 

#ifndef SIP_H
#define SIP_H

/* SIP port classes */
class Psip : public PmISDN
{
	public:
	Psip(int type, int sock, unsigned long host, char *portname, struct port_settings *settings);
	~Psip();

	int p_m_s_socket;
	unsigned long p_m_s_host;
	unsigned char p_m_s_linebuffer[256];
	int p_m_s_readstate;
	unsigned char *p_m_s_bodybuffer;
	int p_m_s_bodylen, p_m_s_bodymax;

	void parse_line(void);
	void parse_body(void);
	int handler(void);
	int message_epoint(unsigned long epoint_id, int message, union parameter *param);
	void message_information(unsigned long epoint_id, int message_id, union parameter *param);
	void message_setup(unsigned long epoint_id, int message_id, union parameter *param);
	void message_notify(unsigned long epoint_id, int message_id, union parameter *param);
	void message_facility(unsigned long epoint_id, int message_id, union parameter *param);
	void message_overlap(unsigned long epoint_id, int message_id, union parameter *param);
	void message_proceeding(unsigned long epoint_id, int message_id, union parameter *param);
	void message_alerting(unsigned long epoint_id, int message_id, union parameter *param);
	void message_connect(unsigned long epoint_id, int message_id, union parameter *param);
	void message_disconnect(unsigned long epoint_id, int message_id, union parameter *param);
	void message_release(unsigned long epoint_id, int message_id, union parameter *param);
};

int sip_init(void);
void sip_cleanup(void);

#endif
