/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg                                              **
**                                                                           **
** Header file for defining fixed values for the current version             **
**                                                                           **
\*****************************************************************************/ 

#ifndef MAIN_H
#define MAIN_H


#define NAME		"PBX4Linux"

#define DEFAULT_ENDPOINT_APP EndpointAppPBX

#define VERSION_STRING	"3.4 (December 2005)"

extern int memuse;
extern int mmemuse;
extern int cmemuse;
extern int ememuse;
extern int pmemuse;
extern int amemuse;
extern int rmemuse;
extern int classuse;
extern int fduse;
extern int fhuse;

#define PDEBUG(mask, fmt, arg...) _printdebug(__FUNCTION__, __LINE__, mask, fmt, ## arg)
#define PERROR(fmt, arg...) _printerror(__FUNCTION__, __LINE__, fmt, ## arg)
#define PDEBUG_RUNTIME(mask, fmt, arg...) _printdebug(NULL, 0, mask, fmt, ## arg)
#define PERROR_RUNTIME(fmt, arg...) _printerror(NULL, 0, fmt, ## arg)
void _printdebug(const char *function, int line, unsigned long mask, const char *fmt, ...);
void printlog(const char *fmt, ...);
void _printerror(const char *function, int line, const char *fmt, ...);

#define DEBUG_CONFIG	0x0001
#define DEBUG_MSG 	0x0002
#define DEBUG_STACK 	0x0004
#define DEBUG_BCHANNEL 	0x0008
#define DEBUG_PORT 	0x0100
#define DEBUG_ISDN 	0x0110
#define DEBUG_OPAL	0x0120 
#define DEBUG_H323	0x0130 
//#define DEBUG_KNOCK	0x0140
#define DEBUG_VBOX	0x0180
#define DEBUG_EPOINT 	0x0200
#define DEBUG_CALL 	0x0400
//#define DEBUG_STALL 	0x0800
#define DEBUG_CRYPT	0x1000
#define DEBUG_ROUTE	0x2000
#define DEBUG_IDLETIME	0x4000
#define DEBUG_LOG	0x7fff

// check any faulty malloc
#define MALLOC_CHECK_	1

/*
 * one of the bits must be enabled in order to write log files
 */
#define DEBUG_LOG	0x7fff

/* audio buffer for mixer and recording.
 * all partys within a call (most time two endpoints) write audio data to the buffer. this is used because
 * the buffer experience jitter. if the buffer is too small, jitter will cause drops and gaps.
 * if the buffer is too large, the delay is large. 768 is a good value to start with.
 */
#ifdef VOIP
#warning to be removed soon
#endif
#define PORT_BUFFER	768

/* keep this 0 for minimum delay */
#ifdef VOIP
#warning to be removed soon
#endif
#define ISDN_PRELOAD	0

/* the jitterlimit specifies the number of samples received too fast, before
 * it recognizes a stalling process.
 * but should NOT be less 256.
 */
#ifdef VOIP
#warning to be removed soon
#endif
#define ISDN_JITTERLIMIT 512	/* maximum samples received before dropping */

/* give sendmail program. if not inside $PATH, give absolute path here (e.g. "/usr/sbin/sendmail")
 */
#define SENDMAIL	"sendmail"

/* maximum number of redial/powerdial and reply numbers to remember
 */
#define MAX_REMEMBER	50

/* leave it above 1024, because lower values can be unsafe, higher valuse cause
 * data larger than 512 bytes of hex strings.
 */
#define RSA_BITS	1536

/* 'goto' or 'menu' actions may cause infinite loops. they will be prevented by this limit.
 * Also other recursions, like redialing the 'redial' action must be prevented.
 * increase it ONLY IF you have a deeper tree of rule sets, than the value given here.
 */
#define RULE_NESTING	10

/* special debugging for buffer overflow bugs
 * note: whenever a buffer gets strange values, the budetect function must
 * be modified to detect the change of these values. whenever it is detected,
 * an error message is given at budetect function.
 */
//#define BUDETECT_DEF

#ifdef BUDETECT_DEF
 #define BUDETECT	budetect(__FILE__, __LINE__, __FUNCTION__);
 void budetect(const char *file, int line, char *function);
#else
 #define BUDETECT	;
#endif

#ifdef H323
#define VOIP
#ifdef OPAL
#error    It is not allowed to use H323 and OPAL. Please disable H323, because it is included in OPAL.
#endif
#endif
#ifdef OPAL
#define VOIP
#endif

#ifdef H323INCLUDE
#define NO_VIDEO_CAPTURE
//#include <vector>
//#include <string>
#include <ptlib.h>
#include <h225.h>
#include <h323.h>
#include <h323pdu.h>
#include <h323caps.h>
#include <q931.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
//#include <asm/bitops.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <isdn_net.h>
#include <net_l3.h>
#ifdef __cplusplus
}
#endif
#include "save.h"
#include "options.h"
#include "interface.h"
#include "h323conf.h"
#include "extension.h"
#include "message.h"
#include "endpoint.h"
#include "endpointapp.h"
#include "apppbx.h"
#include "route.h"
#include "port.h"
#include "mISDN.h"
#include "dss1.h"
#ifdef H323
#include "h323.h"
#endif
#ifdef OPAL
#include "opal.h"
#endif
#include "vbox.h"
#include "call.h"
#include "cause.h"
#include "alawulaw.h"
#include "tones.h"
#include "crypt.h"
#include "admin_server.h"

extern double now_d;
extern time_t now;
extern struct tm *now_tm;
extern struct timeval now_tv;
extern struct timezone now_tz;


#ifdef H323INCLUDE
#include "h323_ep.h"
#include "h323_con.h"
#include "h323_chan.h"

extern PMutex mutex_h323; // mutual exclude for synchroniszing threads 
extern H323_ep *h323_ep;
#endif

#endif
