// PBX OPAL connection


#include "main.h"

#define new PNEW

static PString MakePBXToken(const unsigned long port_id)
{
	return "PBX-Token:" + port_id;
}

todo in welcher reihenfolge wird kreiert, wann muss wo der port erzeugt werden

PBXConnection::PBXConnection(OpalCall &call, PBXEndPoint &ep, const unsigned long port_id)
  : OpalConnection(call, ep, MakePBXToken(port_id));
{
	port_id = port_id;
	PDEBUG(DEBUG_OPAL, "Created OPAL PBX connection.\n");
}


PBXConnection::~PBXConnection()
{
	// send release message
	PBX_LOCK;
	port = find_port_id(port_id);
	if (port)
	{
		message = message_create(port_id, ACTIVE_EPOINT(port->p_epointlist), PORT_TO_EPOINT, MESSAGE_RELEASE);
		message->disconnectinfo.cause = CAUSE_NORMAL;
		message->disconnectinfo.location = LOCATION_LOCALPBX;
		message_put(message);
	}
	port_id = 0;
	PBX_UNLOCK;

	PDEBUG(DEBUG_OPAL, "Terminated OPAL PBX connection.\n");
}


////////////////////////////////////
// IN SETUP (VOIPep->PBXep->Port) //
////////////////////////////////////

BOOL PBXConnection::SetUpConnection()
{
	remotePartyName = ownerCall.GetOtherPartyConnection(*this)->GetRemotePartyName();
	remotePartyNumber = ownerCall.GetOtherPartyConnection(*this)->GetRemotePartyName();
	remotePartyAddress = ownerCall.GetOtherPartyConnection(*this)->GetRemotePartyAddress();
	remoteApplication = ownerCall.GetOtherPartyConnection(*this)->GetRemoteApplication();

	PBX_LOCK;
	
	// create port
	if (!(port = new OpalPort(PORT_TYPE_OPAL_IN, (char *))))
	{
		PBX_UNLOCK;
		return FALSE;
	}
	port_id = port->serial;

	// fill caller information
	SCPY(port->p_callerinfo.id, remotePartyNumber);
	port->p_callerinfo.screen = INFO_SCREEN_USER;
	port->p_callerinfo.present = INFO_PRESENT_ALLOWED;
	port->p_callerinfo.ntype = INFO_NTYPE_UNKNOWN;
	port->p_callerinfo.itype = INFO_ITYPE_VOIP;

	// fill bearer information
	port->p_bearerinfo.capability = INFO_CAPABILITY_SPEECH;
	port->p_bearerinfo.mode = INFO_MODE_CIRCUIT;
	port->p_bearerinfo.codec = (options.law=='u')?INFO_CODEC_ULAW:INFO_CODEC_ALAW;

	// fill dialing information
	SCPY(port->p_dialinginfo.number, "");
        port->p_dialinginfo.ntype = INFO_NTYPE_UNKNOWN;
	port->p_dialinginfo.complete = 1;

	message = message_create(port->p_serial, ACTIVE_EPOINT(port->p_epointlist), PORT_TO_EPOINT, MESSAGE_SETUP);
	message->param.setup.port_type = port->p_type;
	memcpy(&message->param.setup.callerinfo, callerinfo, sizeof(struct caller_info));
	memcpy(&message->param.setup.dialinginfo, dialinginfo, sizeof(struct dialing_info));
	memcpy(&message->param.setup.redirinfo, redirinfo, sizeof(struct redir_info));
	memcpy(&message->param.setup.bearerinfo, bearerinfo, sizeof(struct bearer_info));
	message->param.setup.dtmf = 1;
	message_put(message);

	PBX_UNLOCK;
		
	PDEBUG(DEBUG_OPAL, "IN SETUP: Opal Port created.\n");
	phase = SetUpPhase;

	return TRUE;
}


///////////////////////////////////////
// IN ALERTING (VOIPep->PBXep->Port) //
///////////////////////////////////////

BOOL PBXConnection::SetAlerting(const PString & calleeName, BOOL)
{
	// send altering message
	PBX_LOCK;
	port = find_port_id(port_id);
	if (port)
	{
		message = message_create(port_id, ACTIVE_EPOINT(port->p_epointlist), PORT_TO_EPOINT, MESSAGE_ALERTING);
		message_put(message);
	}
	PBX_UNLOCK;

	PDEBUG(DEBUG_OPAL, "IN ALERTING\n");
	phase = AlertingPhase;
	remotePartyName = calleeName;
	return endpoint.OnShowOutgoing(*this);
}


//////////////////////////////////////
// IN CONNECT (VOIPep->PBXep->Port) //
//////////////////////////////////////

BOOL PBXConnection::SetConnected()
{
	// send altering message
	PBX_LOCK;
	port = find_port_id(port_id);
	if (port)
	{
		message = message_create(port_id, ACTIVE_EPOINT(port->p_epointlist), PORT_TO_EPOINT, MESSAGE_CONNECT);
		message_put(message);
	}
	PBX_UNLOCK;

	PDEBUG(DEBUG_OPAL, "IN CONNECT\n");
	if (mediaStreams.IsEmpty())
		phase = ConnectedPhase;
	else {
	 	phase = EstablishedPhase;
		OnEstablished();
	}
	return TRUE;
}


PString PBXConnection::GetDestinationAddress()
{
	return endpoint.OnGetDestination(*this);
}


OpalMediaFormatList PBXConnection::GetMediaFormats() const
{
	OpalMediaFormatList formats;

	if (options.law == 'u')
		formats += Opal_G711_ULAW_64K;
	if (options.law == 'a')
		formats += Opal_G711_ALAW_64K;

	AddVideoMediaFormats(formats);

	return formats;
}


OpalMediaStream *OpalPBXConnection::CreateMediaStream(const OpalMediaFormat& mediaFormat, unsigned sessionID, BOOL isSource)
{
	if (ownerCall.IsMediaBypassPossible(*this, sessionID))
		return new OpalNullMediaStream(mediaFormat, sessionID, isSource);
	
	return new PBXMediaStream(mediaFormat, isSource, sessionID);
}


void OpalPCSSConnection::PBXSetup()
{
	tbd
  phase = SetUpPhase;
  if (!OnIncomingConnection())
    Release(EndedByCallerAbort);
  else {
    PTRACE(2, "PCSS\tOutgoing call routed to " << ownerCall.GetPartyB() << " for " << *this);
    if (!ownerCall.OnSetUp(*this))
      Release(EndedByNoAccept);
  }
}


void OpalPCSSConnection::PBXDisconnectRelease()
{
}

void OpalPCSSConnection::PBXAlerting()
{
}

void OpalPCSSConnection::PBXConnect()
{
  if (!LockReadOnly())
    return;

  if (phase != AlertingPhase) {
    UnlockReadOnly();
    return;
  }

  LockReadWrite();
  phase = ConnectedPhase;
  UnlockReadWrite();
  UnlockReadOnly();

  OnConnected();

  if (!LockReadOnly())
    return;

  if (mediaStreams.IsEmpty()) {
    UnlockReadOnly();
    return;
  }

  LockReadWrite();
  phase = EstablishedPhase;
  UnlockReadWrite();
  UnlockReadOnly();

  OnEstablished();
}




