/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg                                              **
**                                                                           **
** reading interface.conf file and filling structure                         **
**                                                                           **
\*****************************************************************************/ 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "main.h"

struct interface *interface_first = NULL;


/* read interfaces
 *
 * read settings from interface.conf
 */
char interface_error[256];
struct interface *read_interfaces(void)
{
	FILE			*fp = NULL;
	char			filename[128];
	char			*p;
	char			type[32];
	char			name[256];
	char			ports[256];
	char			extensions[256];
	unsigned int		line, i, ii;
	char			buffer[256];
	struct interface	*interface_start = NULL,
				*interface,
				**interfacep = &interface_start,
				*temp;
	struct mISDNport	*mISDNport;
	int 			links;
	int			pn;

	interface_error[0] = '\0';
	SPRINT(filename, "%s/interface.conf", INSTALL_DATA);

	if (!(fp = fopen(filename,"r")))
	{
		PERROR("Cannot open '%s'\n", filename);
		goto error;
	}

	line=0;
	while((fgets(buffer,sizeof(buffer),fp)))
	{
		buffer[sizeof(buffer)-1]=0;
		if (buffer[0]) buffer[strlen(buffer)-1]=0;
		p=buffer;
		line++;

		while(*p <= 32) /* skip spaces */
		{
			if (*p == 0)
				break;
			p++;
		}
		if (*p==0 || *p=='#') /* ignore comments and empty line */
			continue;

		type[0]=0;
		i=0; /* read type */
		while(*p > 32)
		{
			if (i+1 >= sizeof(type))
			{
				SPRINT(interface_error, "Error in %s (line %d): type keyword too long.\n",filename,line);
				goto error;
			}
			type[i+1] = '\0';
			type[i++] = *p++;
		}

		while(*p <= 32) /* skip spaces */
		{
			if (*p == 0)
				break;
			p++;
		}

		if (*p==0 || *p=='#') /* missing name */
		{
			SPRINT(interface_error, "Error in %s (line %d): missing name of interface.\n",filename,line);
			goto error;
		}

		name[0]=0;
		i=0; /* read name */
		while(*p > 32)
		{
			if (i+1 >= sizeof(name))
			{
				SPRINT(interface_error, "Error in %s (line %d): option too long.\n",filename,line);
				goto error;
			}
			name[i+1] = '\0';
			name[i++] = *p++;
		}

		while(*p <= 32) /* skip spaces */
		{
			if (*p == 0)
				break;
			p++;
		}

		if (*p==0 || *p=='#') /* missing name */
		{
			SPRINT(interface_error, "Error in %s (line %d): missing port(s) for interface.\n",filename,line);
			goto error;
		}

		ports[0]=0;
		i=0; /* read ports */
		while(*p > 32)
		{
			if (i+1 >= sizeof(ports))
			{
				SPRINT(interface_error, "Error in %s (line %d): option too long.\n",filename,line);
				goto error;
			}
			ports[i+1] = '\0';
			ports[i++] = *p++;
		}

		while(*p <= 32) /* skip spaces */
		{
			if (*p == 0)
				break;
			p++;
		}

		extensions[0]=0;
		if (*p!=0 && *p!='#') /* param */
		{
			i=0; /* read param */
			while(*p > 32)
			{
				if (i+1 >= sizeof(extensions))
				{
					SPRINT(interface_error, "Error in %s (line %d): param too long.\n", filename, line);
					goto error;
				}
				extensions[i+1] = '\0';
				extensions[i++] = *p++;
			}
		}

		/* at this point we have all parameters, malloc list */
		interface = (struct interface *)malloc(sizeof(struct interface));
		if (!interface)
		{
			SPRINT(interface_error, "No memory!");
			goto error;
		}
		memuse++;
		memset(interface, 0, sizeof(struct interface));
		/* attach */
		*interfacep = interface;
		interfacep = &interface->next;

		/* check type */
		if (!strncmp(type, "int", 3))
		{
			interface->iftype = IF_INTERN;
		} else
		if (!strncmp(type, "ext", 3))
		{
			interface->iftype = IF_EXTERN;
		} else
		{
			SPRINT(interface_error, "Error in %s (line %d): type '%s' unknown.\n", filename, line, type);
			goto error;
		}

		/* check for extensions on external interfaces */
		if (interface->iftype==IF_EXTERN && extensions[0])
		{
			SPRINT(interface_error, "Error in %s (line %d): Extensions are not allowed for external interfaces.\n",filename,line);
			goto error;
		}

		/* extract ports */
		links = 0;
		p = ports;
		while(42)
		{
			if (*p<'1' || *p>'9')
			{
				SPRINT(interface_error, "Error in %s (line %d): expecting 1-9 for first digit of port number.\n", filename, line);
				goto error;
			}
			pn = 0;
			while(*p>='0' && *p<='9')
			{
				pn = (pn*10) + *p-'0';
				p++;
			}
			mISDNport = mISDNport_first;
			while(mISDNport)
			{
//				printf("port=%d\n",mISDNport->portnum);
				if (mISDNport->portnum == pn)
					break;
				mISDNport = mISDNport->next;
			}
			if (!mISDNport)
			{
				SPRINT(interface_error, "Error in %s (line %d): port number %d not defined in options.conf.\n", filename, line, pn);
				goto error;
			}
			if (*p == ',')
			{
				interface->ports[pn] = 1;
				links++;
				pn = 0;
				p++;
			} else if (*p == '\0')
			{
				interface->ports[pn] = 1;
				links++;
				break;
			} else
			{
				SPRINT(interface_error, "Error in %s (line %d): invalid character '%c' in port number, expecting ',' as seperator.\n", filename, line, *p);
				goto error;
			}
		}

		/* check name and ports */
		temp = interface_start;
		while(temp)
		{
			if (!strcmp(temp->name, name))
			{
				SPRINT(interface_error, "Error in %s (line %d): name '%s' already defined in line %d.\n", filename, line, name, temp->line);
				goto error;
			}
			if (temp != interface)
			{
				i = 0;
				ii = sizeof(temp->ports);
				while(i < ii)
				{
					if (temp->ports[i] && interface->ports[i])
					{
						SPRINT(interface_error, "Error in %s (line %d): port %d already assigned in line %d.\n", filename, line, i, temp->line);
						goto error;
					}
					i++;
				}
			}
			temp = temp->next;
		}

		/* check extensions */
		p = extensions;
		while(42)
		{
			if (*p == '\0')
				break;
			if (*p<'0' || *p>'9')
			{
				SPRINT(interface_error, "Error in %s (line %d): expecting 0-9 for first digit of extension number.\n", filename, line);
				goto error;
			}
			pn = 0;
			while(*p>='0' && *p<='9')
			{
				p++;
			}
			if (*p == ',')
			{
				p++;
			} else if (*p == '\0')
			{
				break;
			} else
			{
				SPRINT(interface_error, "Error in %s (line %d): invalid character '%c' in extension number, expecting ',' as seperator.\n", filename, line, *p);
				goto error;
			}
		}

		/* write line, multilink, name and extensions */
		interface->line = line;
		if (links > 1)
			interface->multilink = 1;
		SCPY(interface->name, name);
		SCPY(interface->extensions, extensions);
	}

	if (fp) fclose(fp);
	return(interface_start);
error:
	PERROR_RUNTIME("%s", interface_error);
	if (fp) fclose(fp);
	free_interfaces(interface_start);
	return(NULL);
}


/*
 * freeing chain of interfaces */
void free_interfaces(struct interface *interface)
{
	struct interface *temp;

	while(interface)
	{
		temp = interface;
		interface = interface->next;
		free(temp);
		memuse--;
	}
}


