/*****************************************************************************\
**                                                                           **
** PBX4Linux                                                                 **
**                                                                           **
**---------------------------------------------------------------------------**
** Copyright: Andreas Eversberg                                              **
**                                                                           **
** mISDN-port header file                                                    **
**                                                                           **
\*****************************************************************************/ 

#ifndef MISDN_H
#define MISDN_H


#define B_STATE_IDLE		0
#define B_STATE_ACTIVATING	1
#define B_STATE_ACTIVE		2
#define B_STATE_DEACTIVATING	3


extern int entity;
extern int mISDNdevice;

/* mISDN port structure list */
struct mISDNport {
	net_stack_t nst; /* MUST be the first entry, so &nst equals &mISDNlist */
	manager_t mgr;
	struct mISDNport *next;
	char interface_name[16]; /* name of interface */
	int iftype; /* IF_* */
	int multilink; /* if set, this port will not support callwaiting */
	int portnum; /* port number */
	int ptp; /* if ptp is set, we keep track of l2link */
	int l1link; /* if l1 is available (only works with nt-mode) */
	int l2link; /* if l2 is available (at PTP we take this serious) */
//	time_t l1timeout; /* timout when establishing link */
	time_t l2establish; /* time until establishing after link failure */
	int use; /* counts the number of port that uses this port */
	int ntmode; /* is TRUE if port is nt mode */
	int pri; /* is TRUE if port is a primary rate interface */
	int upper_id; /* id to transfer data down */
	int lower_id; /* id to transfer data up */
	int d_stid;
	int b_num; /* number of ports */
	class PmISDN *b_port[256]; /* maximum number of ports shall be 256 due to S0 / E1 / Loop */
	int b_stid[256];
	int b_addr[256];
	int b_state[256]; /* state 0 = IDLE */
	int procids[256]; /* keep track of free ids */
	msg_queue_t downqueue;		/* l4->l3 */
};
extern mISDNport *mISDNport_first;


/* mISDN none-object functions */
void mISDN_port_info(void);
int mISDN_port_open(int port, int ptp);
void mISDN_port_close(void);
void mISDN_port_reorder(void);
int mISDN_handler(void);
void enc_ie_cause_standalone(unsigned char **ntmode, msg_t *msg, int location, int cause);
void ph_control(unsigned long b_addr, int c1, int c2);
void ph_control_block(unsigned long b_addr, int c1, void *c2, int c2_len);
msg_t *create_l2msg(int prim, int dinfo, int size);
void setup_queue(struct mISDNport *mISDNport, int link);
int stack2manager_nt(void *dat, void *arg);
int stack2manager_te(struct mISDNport *mISDNport, msg_t *msg);


/* mISDN port classes */
class PmISDN : public Port
{
	public:
	PmISDN(int type, struct mISDNport *mISDNport, char *portname, struct port_settings *settings);
	~PmISDN();
	void bchannel_receive(iframe_t *frm);
	int handler(void);
	int message_epoint(unsigned long epoint_id, int message, union parameter *param);
	void message_mISDNsignal(unsigned long epoint_id, int message_id, union parameter *param);
	void message_crypt(unsigned long epoint_id, int message_id, union parameter *param);
	struct mISDNport *p_m_mISDNport;	/* pointer to port */
	int p_m_txvol, p_m_rxvol;		/* volume shift (0 = no change) */
	int p_m_echo, p_m_conf;			/* remote echo, conference number */
	int p_m_tone;				/* current kernel space tone */
	int p_m_rxoff;				/* rx from driver is disabled */
	int p_m_nodata;				/* all parties within a conf are isdn ports, so pure bridging is possible */
	int p_m_txmix;				/* mix tx with conference */
	int p_m_txmix_on;			/* delay for turning back on after sending a binary message, must be signed */
	int p_m_dtmf;				/* dtmf decoding is enabled */

	int p_m_crypt;				/* encryption is enabled */
	int p_m_crypt_msg_loops;		/* sending a message */
	int p_m_crypt_msg_len;
	unsigned char p_m_crypt_msg[1100];
	int p_m_crypt_msg_current;
	unsigned char p_m_crypt_key[128];
	int p_m_crypt_key_len;
	int p_m_crypt_listen;
	int p_m_crypt_listen_state;
	int p_m_crypt_listen_len;
	unsigned char p_m_crypt_listen_msg[1100];
	unsigned long p_m_crypt_listen_crc;
	void cryptman_listen_bch(unsigned char *p, int l);

	void set_tone(char *dir, char *name);
	void set_echotest(int echotest);

	int p_m_portnum;			/* used port number (1...n) */
	int p_m_b_index;			/* index 0,1 0..29 */
	int p_m_b_channel;			/* number 1,2 1..15,17..31 */
	int p_m_b_stid;				/* current stack id */
	int p_m_b_addr;				/* current layer address */
	long long p_m_jittercheck;		/* time of audio data */
	long long p_m_jitterdropped;		/* number of bytes dropped */
	int p_m_delete;				/* true if obj. must del. */
	int p_m_hold;				/* if port is on hold */
	unsigned long p_m_timeout;		/* timeout of timers */
	time_t p_m_timer;			/* start of timer */

	int alloc_bchannel(int channel, int exclusive);
	void free_bchannel(void);
};

extern unsigned char mISDN_rand[256]; /* noisy randomizer */

#endif
